<?php
/* --------------------------------------------------------------
   ProductConditionNoticeTextPhraseService.php 2021-12-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace GXModules\Gambio\ProductConditionNotice\Services;

/**
 * Interface ProductConditionNoticeTextPhraseService
 *
 * @package GXModules\Gambio\ProductConditionNotice\Services
 */
interface ProductConditionNoticeTextPhraseService
{
    /**
     * Return the text phrase for the provided text phrase name.
     *
     * @param string $phraseName
     *
     * @return string
     */
    public function getTextPhrase(string $phraseName): string;
}